package test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import sselibrary.SSEDataPublisher;
import sselibrary.SSEDataSubscriber;

/**
 * @author ericjbruno
 */
public class QueueSender {
	protected static String messageServerURI = "http://localhost:8080/messageserver";
	protected static String queueName = "queue1";
	protected static SSEDataPublisher dataPublisher = null;
	
    String cloudAuthString = "test:welcome1";
    
	protected static String authCode = null;

	Thread CANDataListener = null;
	boolean listening = true;
	
	//////////////////////////////////////////////////////////////////////////
	
	public static void main(String[] args) {
		// Read in CAN sender address and port, and the SSE server address and port
		//
		QueueSender.loadConfigs();
		
		try {
			QueueSender sender = new QueueSender();
		}
		catch ( Exception e ) {
			e.printStackTrace();
		}
	}
	
	public QueueSender() throws Exception {
		// Generate fake test data
		//
		new Thread() {
			public void run() {
				int i = 0;
				while ( i < 100 ) {
					try {
						QueueSender.sendToServer("Message " + i++);
					}
					catch ( Exception e ) { 
                        e.printStackTrace();
                    }
				}
			}
		}.start();
	}
	
	protected static void loadConfigs() {
		// Attempt to load a properties file if found
		//
		Properties props = new Properties();

		try ( FileInputStream in = 
				new FileInputStream(
						new File("./sender.properties")) ) {

			props.load(in);

			QueueSender.messageServerURI = 
					props.getProperty("MessageServerURI", 
										QueueSender.messageServerURI);

		}
		catch ( Exception e ) {
			e.printStackTrace();
		}
		
		log("-----------------------------");
		log("Using MessageServerURI="+messageServerURI);
		log("-----------------------------");
	}
	
	public boolean connectToServer() {
		return false;
	}
	
	public static void sendToServer(String data) throws Exception {
		String url = messageServerURI + "/api/queue/publish?name=" + queueName;
        SSEDataPublisher.sendMessage(url, data, authCode);
	}
	
    public static void log(String s) {
        System.out.println("[QueueSender] " + s);
    }
}
