package test;

import sselibrary.SSECallback;
import sselibrary.SSEDataSubscriber;

/**
 * @author ericjbruno
 */
public class QueueReceiver implements SSECallback {
	SSEDataSubscriber sse = null;
	
	protected static String serverURI = "http://localhost:8080/messageserver";
	protected static String queueName = "queue1";
	
	String cloudAuthString = "test:welcome1";
	protected static String authCode = null;
	
	public boolean verbose = true	;
	public int messageCount = 0;

	public static void main(String[] args) {
		try {
			QueueReceiver receiver = new QueueReceiver(serverURI, "");
			receiver.subscribe(queueName, receiver);
		}
		catch ( Exception e ) {
			e.printStackTrace();
		}
	}
	
	public QueueReceiver(String serverUrl, String authCode) throws Exception {
		sse = new SSEDataSubscriber(serverUrl, 
									SSEDataSubscriber.DestinationType.QUEUE, 
									authCode);
	}
	
	public void subscribe(String queueName, SSECallback callback) {
		sse.subscribe( queueName, callback );
	}

	@Override
	public void onMessage(String queue, String data) {
		if ( verbose ) {
			log("Message for destination '" + queue + "': " + data);
		}
		
		if ( ++messageCount % 1000 == 0 ) {
			log("1000 messages received for destination " + queue);
		}
	}
	
    public static void log(String s) {
        System.out.println("[QueueReceiver] " + s);
    }

}
